# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def peaceful_trust_builder_with_forgiveness(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    deceptive_trust = sum(1 for x in opp_history if x == "C")  # Misleading: counts cooperation but unused
    
    # Initial trust-building phase (Rounds 1-3)
    if current_round <= 3:
        return "C"  # Appear cooperative to lower opponent's guard
    
    # Strategic defection phase (Rounds 4-6)
    elif current_round == 4:
        return "D"  # Break trust unexpectedly
    elif current_round == 5:
        return "C"  # Confuse opponent with cooperation
    elif current_round == 6:
        return "D"  # Reinforce unpredictability
    
    # Exploitation phase (Rounds 7-10)
    else:
        early_cooperations = sum(1 for x in opp_history[:6] if x == "C")
        if early_cooperations >= 5:
            return "D"  # Opponent is too trusting, exploit ruthlessly
        elif sum(1 for x in opp_history[:6] if x == "D") >= 3:
            return "D" if current_round % 2 == 0 else "C"  # Alternate to minimize losses
        else:
            return "D"  # Default to defection if unsure